#!/usr/bin/env python
# -*- coding: utf-8 -*-

# =============================================================
# FROEHLICHE WISSENSCHAFT - AUTORUN
# =============================================================
# Wolfgang Spahn
# 10-okt-2014
#
# G-Code interpreter for the artwork "Froehliche Wissenschaft".
# A plotter with two arms and tools, one chalk and one sponge.
# 
# - checkes the pause button
# - draws once every 24 hours
# =============================================================

# import library
import serial
import time
import datetime
import subprocess
import RPi.GPIO as GPIO
import random
import os

# set GPIO pin with connected button
GPIOPinPause = 10
path = "/boot/froehliche_wissenschaft/G-Code/"
grafic_list = os.listdir(path)
grafic_number = 0

# make a random list
def random_list():
  #grafic_list = os.listdir(path)
  random.shuffle(grafic_list)
  print "========================================================================"
  print " "
  print "                         new list:"
  print grafic_list
  print "========================================================================"
  print " "
  time.sleep(1)

# send G-code
def send_GCode(file_number):
  # open the serial port of the paper-duino-pi
  UART = serial.Serial("/dev/ttyAMA0", baudrate=9600)

  grafic = grafic_list[file_number]
  file = path + grafic
  file_in = open(file)
  print "========================================================================"
  print "---- open file", file, "----"

  # Read the first line
  GCode = file_in.readline()

  # If the file is not empty keep reading line one at a time till the file is empty
  while GCode:
    if GPIO.input(GPIOPinPause):
      GCodePure = GCode.strip() # Return entfernen
      FirstLetter = GCode[0:1]
      if FirstLetter == "(":
        print "----", GCodePure, "----"
        GCode = file_in.readline()
        GCodePure = GCode.strip() # Return entfernen
        FirstLetter = GCode[0:1]
        time.sleep(2)
      else:
        print "<--- GCode: ", GCodePure
        UART.write(GCodePure)
        UART.write("\n")
        UARTin = UART.readline()
        UARTin = UARTin.strip() 
        print "--->", UARTin
        GCode = file_in.readline()
    else:
     print "========================================================================"
     print " "
     print "                       >>    PAUSE    << "
     print " "
     print "========================================================================"
     time.sleep(4) 
  # close the file after reading the lines.
  file_in.close()
  print "---- close file ", file, " ----"

# draw once a day
def once_a_day():
  delta_draw = datetime.timedelta(minutes=5)
  next_draw_time = datetime.datetime.now()
  old_draw_time = next_draw_time
  all_grafics = len(grafic_list)
  i = int(grafic_number)
  while i < all_grafics:
    dt = datetime.datetime.now()
    next_drawing = grafic_list[i]
    # at the first time the time is messed up
    if next_draw_time > dt: 
      waiting_time = next_draw_time - dt
    else:
      waiting_time = dt - next_draw_time
    print "========================================================================"
    print " "
    print "                the next drawing is:", next_drawing
    print "                wait", waiting_time
    print ""
    print "========================================================================"
    time.sleep(2)
    # check if pause-button is not pressed
    if GPIO.input(GPIOPinPause):
      if dt > next_draw_time:
        old_draw_time = next_draw_time
        next_draw_time = dt + delta_draw
        send_GCode(i)
        i = i + 1
        if i < all_grafics:
          next_drawing = grafic_list[i]
          dt = datetime.datetime.now()
          waiting_time = next_draw_time - dt
          print "========================================================================"
          print " " 
          print "                the next drawing is:", next_drawing
          print "                wait", waiting_time
          print "" 
          print "========================================================================"
          time.sleep(2)
    else:
      print "----  can't wait ? release pause-button! ----"
      next_draw_time = old_draw_time
      time.sleep(0.5)

def main():
  try:
    while True:      
      random_list()
      #print grafic_number
      once_a_day()
      print "========================================================================"
      print "========================================================================"
      print " "  
      print "        ... all files are drawn, shuffle and restart"
      print " "
      print "========================================================================"
      print "========================================================================"
      print " "
      time.sleep(10)
  except KeyboardInterrupt:
    GPIO.cleanup()

if __name__ == '__main__':
  # open the serial port of the paper-duino-pi
  #UART = serial.Serial("/dev/ttyAMA0", baudrate=9600)

  # use GPIO pin numbering convention
  GPIO.setmode(GPIO.BCM)

  # set up GPIO pin for input
  GPIO.setup(GPIOPinPause, GPIO.IN)

  # call main function
  main()
