#!/usr/bin/env python
# -*- coding: utf-8 -*-

# =============================================================
# FROEHLICHE WISSENSCHAFT
# =============================================================
# Wolfgang Spahn
# 03-okt-2014
#
# G-Code interpreter for the artwork "Froehliche Wissenschaft".
# A plotter with two arms and tools, one chalk and one sponge.
#
# - checkes the pause button
# - runs manual input
# - draws once a day
# =============================================================


# import library
import serial
import time
import subprocess
import RPi.GPIO as GPIO
#import random

# set GPIO pin with connected button
GPIOPinPause = 10

# main function
def main():
  # open the serial port of the paper-duino-pi
  UART = serial.Serial("/dev/ttyAMA0", baudrate=9600)

  while True:
    # check if pause-button is pressed
    print "================================================================"
    print "                             MANUAL CONTROL"
    print "================================================================"
    Command = raw_input("please type a command (h for help):\n")
    ParsedCommand = Command[0]
    if ParsedCommand == 'h':
      print "---- help file -----"
      print "G-Code Commands:"
      print "G00  rapid possitioning                         G00 X03 Y999"
      print "G01  linear interpolation                       G01 X21 Y44"
      print "G02  circular interpolation clockwise           G02 X10 Y10 I-0 J-5"
      print "G03  circular interpolation counterclockwise    G03 X1032 Y995 I-533 J-0"
      print "G28  return to home possition"
      print "G30  return to chalk filling station"
      print " "
      print "M02  end of program"
      print "M03  spindle on  - tool down"
      print "M05  spindle stop - tool up"
      print "M70  use the chalk"
      print "M71  use the sponge"
      print "M72  scale factor"
      print "M73  switch to linear interpolation"
      print "M74  switch to circular interpolation"
      print "M77  set new zero point"
      print "M78  manual control, 1 = right, 2 = up, 3 = left, 4 = down     M78X1"
      print "M79  reset"
      print "M80  chalksupply, 1 = in 2 = out"
      print "M81  meshure the chalk distance"
      print ""
      print "Draw a File:"
      print "d file.txt"
    elif ParsedCommand == 'd':
      File = '/boot/froehliche_wissenschaft/Test_Files/' + Command[2:]
      # Open the file with read only permit
      FileIn = open(File, 'r')
      print "---- open file ", File, " ----"
 
      # Read the first line
      GCode = FileIn.readline()

      # If the file is not empty keep reading line one at a time till the file is empty
      while GCode:
        GCodePure = GCode.strip() # Return entfernen
        FirstLetter = GCode[0:1]
        if FirstLetter == "(":
          print GCodePure
          GCode = FileIn.readline()
          GCodePure = GCode.strip() # Return entfernen
          FirstLetter = GCode[0:1]
          time.sleep(2)
        else:
          print "<--- GCode: ", GCodePure
          UART.write(GCodePure)
          UART.write("\n")
          UARTin = UART.readline()
          UARTin = UARTin.strip()
          print "--->", UARTin
          GCode = FileIn.readline()
      # close the file after reading the lines.
      FileIn.close()
      print "---- close file:", File, " ----"

    elif ParsedCommand == 'G':
      print "<--- G-Code: ", Command
      UART.write(Command)
      UART.write("\n")
      UARTin = UART.readline()
      UARTin = UARTin.strip()
      print "--->", UARTin
         
    elif ParsedCommand == 'M':
      print "<--- G-Code: ", Command
      UART.write(Command)
      UART.write("\n")
      UARTin = UART.readline()
      UARTin = UARTin.strip()
      print "--->", UARTin
 
    else:
      print "---- unknown command:", Command, ", type h for help! ----"
 
  # wait 500ms
  time.sleep(0.5)

if __name__ == '__main__':

  # open the serial port of the paper-duino-pi
  #UART = serial.Serial("/dev/ttyAMA0", baudrate=9600)

  # use GPIO pin numbering convention
  GPIO.setmode(GPIO.BCM)

  # set up GPIO pin for input
  GPIO.setup(GPIOPinPause, GPIO.IN)

  # call main function
  main()
