/********************************************************************
 * Kreidespender
 ********************************************************************
 *
 * Wolfgang Spahn
 * 9-okt-2014
 *
 *
 ********************************************************************/


int MagnetSensor = A0;
int SensorWert;
int ControlLED = 13;

// Motor
int MotorPin = 10;      // Pins fuer den Analogausgang
int Richtung1 = 11;
int Richtung2 = 12;
int Geschwindigkeit = 255;

// End und Home Schalter
int EndSchalterPin = 3;
int HomeSchalterPin = 4;
int EndSchalter = HIGH;
int HomeSchalter = HIGH;

void setup(){
  pinMode(ControlLED, OUTPUT);

  pinMode(MotorPin, OUTPUT);
  pinMode(Richtung1, OUTPUT);
  pinMode(Richtung2, OUTPUT);
  digitalWrite(Richtung1, LOW);
  digitalWrite(Richtung2, LOW);

  pinMode(EndSchalterPin, INPUT_PULLUP);
  pinMode(HomeSchalterPin, INPUT_PULLUP);

  Serial.begin(9600);        // Serielle Verbindung konfigurieren
}


void loop(){
  WerteMessen();
  if (SensorWert < 485) {
    Serial.println("KreideAusgabe");
    EndSchalter = digitalRead(EndSchalterPin);
    Serial.print("EndSchalter:");
    Serial.println(EndSchalter);
    KreideAusgabe();
    delay(20000);
  }
  else if (SensorWert > 505) {
    Serial.println("KreideRueckstellung");
    HomeSchalter = digitalRead(HomeSchalterPin);
    Serial.print("HomeSchalter:");
    Serial.println(HomeSchalter);
    KreideRueckstellung();
  }
  Senden();
}


/********************************************************************/
// Messen des Magnetfeldes

void WerteMessen(){
  SensorWert = 0;
  // Normalwert ist 511 bei Magnetischem Feld 445 bis 470
  for (int i= 0; i<10; i++) {
    SensorWert = SensorWert + analogRead(MagnetSensor);
    delay(100);
  }
  SensorWert = SensorWert / 10;
}

/********************************************************************/
// Motor Steuerung

void MotorRaus(){
  digitalWrite(Richtung1, HIGH);
  digitalWrite(Richtung2, LOW);
  analogWrite(MotorPin, Geschwindigkeit);
}

void MotorEin(){
  digitalWrite(Richtung1, LOW);
  digitalWrite(Richtung2, HIGH);
  analogWrite(MotorPin, Geschwindigkeit);
}

void MotorAus(){
  digitalWrite(Richtung1, HIGH);
  digitalWrite(Richtung2, LOW);
  analogWrite(MotorPin, 0);
}

/********************************************************************/
// Kreide Ausgabe

void KreideAusgabe(){
  while (EndSchalter == HIGH){
    EndSchalter = digitalRead(EndSchalterPin);
    //Blinken();
    MotorRaus();
  }
  MotorAus();
}

/********************************************************************/
// Ru:ckstellen 

void KreideRueckstellung(){
  while (HomeSchalter == HIGH){
    HomeSchalter = digitalRead(HomeSchalterPin);
    //Blinken();
    MotorEin();
  }
  MotorAus();
}


/********************************************************************/
// Seriel Schreiben

void Senden(){
  Serial.println(SensorWert);
  delay(200);
}


/********************************************************************/
// Blinken

void Blinken(){
  digitalWrite(ControlLED, HIGH);   
  delay(50);                  
  digitalWrite(ControlLED, LOW);   
  delay(50);  
}









