/***********************************************************************************
 * Data Control - Main Program
 ***********************************************************************************
 *
 * reads the serial input
 * parse the G-Code
 *
 * the following G-Codes are implemented:
 *  - G 00  rapid possitioning                         G00 X03 Y999
 *  - G 01  linear interpolation                       G01 X21 Y44
 *  - G 02  circular interpolation clockwise           G02 X10 Y10 I-0 J-5
 *  - G 03  circular interpolation counterclockwise    G03 X1032 Y995 I-533 J-0
 *  - G 28  return to home possition
 *  - G 30  return to secondary home possition (get chalk)
 *
 *  - M 02  end of program
 *  - M 03  spindle on  - tool down
 *  - M 05  spindle stop - tool up
 *
 * special codes:
 *  - M 70 use chalk
 *  - M 71 use sponge
 *  - M 72 scale factor
 *  - M 73 switch to linear interpolation
 *  - M 74 switch to circular interpolatio
 *  - M 77 new zero point
 *  - M 78 manual control, 1 = right, 2 = up, 3 = left, 4 = down
 *  - M 79 test
 *  - M 80 chalksupply, 1 = in 2 = out
 *  - M 81 meshure the distance
 *
 ************************************************************************************/


void DataControl(){
  // if there's any serial available, read it:
  while (Serial.available() > 0) {
    // look for the next valid integer in the incoming serial stream:
    CommandType1 = Serial.read(); 
    if (CommandType1 == '\n') Serial.println("No-Code --->");
    else{
      Command1 = Serial.parseInt(); 
      // parse G-Code commands:
      if (CommandType1 =='G'){
        parse_G_code();
      }
      // parse M-Code commands:
      if (CommandType1 =='M'){
        parse_M_Code();
      }
    }
  }
}

/***********************************************************************************/
// parse the X and Y coordinates

void ReadXY(){
  CommandType2 = Serial.read();
  Command2 = Serial.parseFloat();
  if (Serial.read() == '\n') {     // case of a feedrate command
    Serial.print("feed rate is:");
    Serial.println(Command2);
  }
  else{
    CommandType3 = Serial.read(); 
    Command3 = Serial.parseFloat();
  }
}

// parse the I or R command
void ReadI(){
  CommandType4 = Serial.read();
  Command4 = Serial.parseFloat();
}

// parse the J command
void ReadJ(){
  CommandType5 = Serial.read(); 
  Command5 = Serial.parseFloat();
}

/***********************************************************************************/
// scale
void Scale(){
  Command2 = Command2 * ScaleFactor;
  Command3 = Command3 * ScaleFactor;
  Command4 = Command4 * ScaleFactor;
  Command5 = Command5 * ScaleFactor;
}
// set the new X and Y coordinates
void NewXY(){
  XNew = (float)Command2;           // change float into integer
  int RestX = (int)(10*(Command2 - (float)XNew));
  if (RestX >= 5) XNew = XNew + 1;
  
  YNew = (float)Command3; 
  int RestY = (int)(10*(Command3 - (float)YNew));
  if (RestY >= 5) YNew = YNew + 1; 
  
  XCircleDistance = (float)Command4;
  int RestXC = (int)(10*(Command4 - (float)XCircleDistance));
  if (RestXC >= 5) XCircleDistance = XCircleDistance + 1;
  
  YCircleDistance = (float)Command5;
  int RestYC = (int)(10*(Command5 - (float)YCircleDistance));
  if (RestYC >= 5) YCircleDistance = YCircleDistance + 1;
}

/***********************************************************************************/
// choose tool, turn sponge ON and OFF, go to linear or circular interpolation

void LinearChoose(){
  if (ToolChoice == 1) LinearInterpolation();
  else if (ToolChoice == 2){
    SpongeOn();
    LinearInterpolation();
    SpongeOff();
    delay(200);
  }
}

void CircularChooseCW(){
  if (ToolChoice == 1) CircularInterpolationCW();
  else if (ToolChoice == 2){
    SpongeOn();
    CircularInterpolationCW();
    SpongeOff();
    delay(200);
  }
}

void CircularChooseCCW(){
  if (ToolChoice == 1) CircularInterpolationCCW();
  else if (ToolChoice == 2){
    SpongeOn();
    CircularInterpolationCCW();
    SpongeOff();
    delay(200);
  }
}

/***********************************************************************************/
// parse G-Code commands:

void parse_G_code(){
  switch (Command1) {
    // G00 Rapid positioning
  case 0:                                    
    ReadXY();
    if (Serial.read() == '\n') {      // look for the newline. That's the end of the sentence:
      Scale();
      NewXY();
      LinearInterpolation();//RapidPositioning();
      SendMessage();
    }
    break;
    // G01 Linear interpolation:  
  case 1:                                 
    ReadXY();
    if (Serial.read() == '\n') {
      Scale();
      NewXY();
      LinearChoose();
      SendMessage();
    }
    break;
    // G02 Circular interpolation, clockwise:
  case 2:
    ReadXY();
    ReadI();
    if (Serial.read() == '\n') {
      Scale();
      NewXY();
      LinearChoose();
      Serial.print("linear interpolation instead of a circle with radius:");
      Serial.println(Command4);
    }
    else{
      ReadJ();
      if (Serial.read() == '\n') {
        Scale();
        NewXY();
        if (Linear == 0) {
          CircularChooseCW();
        }
        else{ 
          LinearChoose();
        }
        SendMessage();
      }
    }
    break;
    // G03 Circular interpolation, counterclockwise:
  case 3:
    ReadXY();
    ReadI();
    if (Serial.read() == '\n') {
      Scale();
      NewXY();
      LinearChoose();
      Serial.print("linear interpolation instead of a circle with radius:");
      Serial.println(Command4);
    }
    else{
      ReadJ();
      if (Serial.read() == '\n') {
        Scale();
        NewXY();
        if (Linear == 0){ 
          CircularChooseCCW();
        }
        else {
          LinearChoose();
        }
        SendMessage();
      }
    }
    break;
    // G28 return to home position          
  case 28:
    if (Serial.read() == '\n') {
      GoingHome();
      EverythingOff();
      Serial.println("return to home position");
    }
    break;
    // G30 return to secondary home position (chalk position)        
  case 30:
    if (Serial.read() == '\n') {
      GoingForNewChalk();
      Serial.println("return to chalk position");
    }
    break; 
  }
}

/***********************************************************************************/
// parse M-Code commands:

void  parse_M_Code(){  
  switch (Command1) {
    // M02 End of program
  case 2:
    if (Serial.read() == '\n') {
      Serial.print("end of G-Code file, going home");
      GoingHome();
      Serial.print(", X:-");
      Serial.print(HomeXSteps);
      Serial.print(" Y:-");
      Serial.print(HomeYSteps);
      EverythingOff();
      //ChalkCheck(); // check if the chalk is long enough, if not take a new one
      //ChalkArmControlDown();
      //CheckChalkDistance();
      Serial.print(" and go for the waiting possition turn off everything");
      ChalkArmControlUp();
      GoingForWait();
      EverythingOff();
      Serial.println(" --->");
    }
    break;
    // M03 Tool down
  case 3:
    SteppCheckY = 0;
    if (Serial.read() == '\n') {
      if (ToolChoice == 1){
        ChalkArmControlDown();
        Serial.print("chalk down, ");
        delay(400);           // delay is needed for exact measurement
        ChalkCheckOnTheFly();
        CheckChalkDistance();
      }  
      if (ToolChoice == 2){
        SpongeArmControlDown();
        Serial.print("sponge down");
      }
      Serial.println(" --->");
    }
    break;
    // M05 Tool Up
  case 5:
    SteppCheckY = 0;
    if (Serial.read() == '\n') {
      if (ToolChoice == 1){
        ChalkArmControlUp();
        Serial.print("chalk up");
      }
      if (ToolChoice == 2){
        SpongeArmControlUp();
        Serial.print("sponge up");
      }
      Serial.println(" --->");
    }
    break;
    // M70 use chalk
  case 70:         
    ToolChoice = 1;
    if (Serial.read() == '\n') {
      Serial.print("start chalk drawing");
      Serial.println(" --->");
    }
    break;
    // M71 use sponge
  case 71:       
    ToolChoice = 2;
    if (Serial.read() == '\n') {
      Serial.print("start sponge drawing");
      Serial.println(" --->");
    }
    break;
    // M72 scale factor
  case 72:       
    CommandType2 = Serial.read(); 
    ScaleFactor = Serial.parseInt();
    if (Serial.read() == '\n') {
      Serial.print("scale: ");
      Serial.print(ScaleFactor);
      Serial.println(" --->");
    }
    // M73 switch to linear interpolation
  case 73:        
    Linear = 1;
    if (Serial.read() == '\n') {
      Serial.print("switch to linear interpolation");
      Serial.println(" --->");
    }
    break;
    // M74 switch to circular interpolation  
  case 74:
    Linear = 0;
    if (Serial.read() == '\n') {
      Serial.print("switch to circular interpolation");
      Serial.println(" --->");
    }
    break;
    // M77 New zero point
  case 77:
    if (Serial.read() == '\n') {
      XOld = 0;
      YOld = 0;
      Serial.print("new zero point");
      Serial.println(" --->");
    }
    break;
    // Manuell Move 1 = right, 2 = up, 3 = left, 4 = down  
  case 78:       
    CommandType2 = Serial.read(); 
    Direction = Serial.parseInt();
    if (Serial.read() == '\n') {
      ManualControl();
      Serial.println(" --->");
    }
    break;
    // M79 Test
  case 79:  
    if (Serial.read() == '\n'){
      EverythingOff();
      Serial.print("turn off everything");
      Serial.println(" --->");
    }
    break;
    //M 80 chalksupply, 1 = in 2 = out
  case 80:  
    CommandType2 = Serial.read(); 
    Direction = Serial.parseInt();
    if (Serial.read() == '\n'){
      ManualChalkSupplyControl();
      Serial.println(" --->");
    }
    break;
    //M 81 meshure the distance
  case 81:  
    if (Serial.read() == '\n'){
      MeasureChalkDistance();
      Serial.print("distance:");
      Serial.print(ChalkDistanceSensor);
      Serial.println(" --->");
    }
    break;
  }
}














