/********************************************************************
 * Get a New Chalk
 ********************************************************************
 *
 * - Run Out Of Chalk
 * - Chalk Distance
 * - Going to Chalk Possition
 *
 ********************************************************************/


/*******************************************************************/
// Take a new chalk

void TakeNewChalk(){
  RunOutOfChalk = digitalRead(RunOutOfChalkPin);
  while (RunOutOfChalk == LOW) {
    RunOutOfChalk = digitalRead(RunOutOfChalkPin);
    ChalkSupplyMotorIn();
  }
  delay(6500);
  ChalkSupplyMotorOff();
  ChalkArmControlUp();
}


/*******************************************************************/
// Get rid of chalk rest

void GetRidOfChalkRest(){
  ChalkArmControlUp();
  ChalkSupplyMotorOut();
  delay(8000);
  ChalkSupplyMotorOff();
  delay(1000);
}

/********************************************************************/
// Going to the possition for a new chalk

void GoingForNewChalk(){
  // go to X100 Y5910
  Command2 = 100;
  Command3 = 5910;
  NewXY();
  LinearInterpolation();
  ChalkArmControlDown(); 
}

/********************************************************************/
// Check if there is still enough chalk, if not take a new one
void ChalkCheck(){ 
  RunOutOfChalk = digitalRead(RunOutOfChalkPin);
  Serial.print(", check chalk:");
  Serial.print(RunOutOfChalk);
  if (RunOutOfChalk == LOW) {
    Serial.print("=> going for a new chalk");
    GetRidOfChalkRest();
    GoingForNewChalk();
    delay(10000);  // time until the chalk store gives out a chalk
    Serial.print(", take a new chalk");
    TakeNewChalk();
    Serial.print(", going home");
    GoingHome(); 
  }
} 

/********************************************************************/
// While the program is drawing:
// Check if there is still enough chalk, if not take a new one
void ChalkCheckOnTheFly(){ 
  RunOutOfChalk = digitalRead(RunOutOfChalkPin);
  Serial.print(", check chalk:");
  Serial.print(RunOutOfChalk);
  if (RunOutOfChalk == LOW) {
    XNewBreak = XOld;
    YNewBreak = YOld;
    ChalkArmControlUp();
    GoingHome();
    HomeXSteps = 0;
    HomeYSteps = 0,
    Serial.print("=> going for a new chalk");
    GetRidOfChalkRest();
    GoingForNewChalk();
    delay(10000);  // time until the chalk store gives out a chalk
    Serial.print(", take a new chalk");
    TakeNewChalk();
    Serial.print(", going home");
    GoingBack(); 
  }
} 

/********************************************************************/
//Check the distance between chalkarm and board

void MeasureChalkDistance(){
  ChalkDistanceSensor = 0;   // reset measurement
  for (int i=0; i < 10; i++){
    ChalkDistanceSensor = ChalkDistanceSensor + analogRead(ChalkDistanceSensorPin);
    delay(10);
  }
  ChalkDistanceSensor = ChalkDistanceSensor / 10;
}

void CheckChalkDistance(){
  Serial.print(", check chalk ");
  MeasureChalkDistance();
  Serial.print("distance:");
  Serial.print(ChalkDistanceSensor);
  if (ChalkDistanceSensor > 460){
    ChalkDistanceToSmal(); 
  }
  else if (ChalkDistanceSensor < 430){  //430
    ChalkDistanceToBig(); 
  }
}

void ChalkDistanceToSmal(){
  while (ChalkDistanceSensor > 460){  //450
    ChalkSupplyMotorOut();
    delay(200);
    ChalkSupplyMotorOff();
    MeasureChalkDistance();
  }
  Serial.print(" => chalk supply out, new distance:");
  Serial.print(ChalkDistanceSensor);
}

void ChalkDistanceToBig(){
    while (ChalkDistanceSensor < 430){
    ChalkSupplyMotorIn();
    delay(200);
    ChalkSupplyMotorOff();
    MeasureChalkDistance();
  }
  Serial.print(" => chalk supply in, new distance:");
  Serial.print(ChalkDistanceSensor);
}

/*******************************************************************/
// chalk distance motor control

void ChalkSupplyMotorIn(){
  digitalWrite(ChalkMotor1Pin, HIGH);
  digitalWrite(ChalkMotor2Pin, LOW);
}

void ChalkSupplyMotorOut(){
  digitalWrite(ChalkMotor1Pin, LOW);
  digitalWrite(ChalkMotor2Pin, HIGH);
}
void ChalkSupplyMotorOff(){
  digitalWrite(ChalkMotor1Pin, LOW);
  digitalWrite(ChalkMotor2Pin, LOW);
}

/*******************************************************************/




