/****************************************************************************
 * Stepper Controll
 ****************************************************************************
 *
 * Controlles the steppermotors - direction and stepps
 * the delay is the time each coil of the steppermotor is powered
 *
 * 1 = right
 * 2 = up - changed from down
 * 3 = left
 * 4 = down - changed from up
 *
 * change to 3 times up and down cause of the new gears 1:15 (old 1:5)
 * before move, test if End- or Home-Switches are triggert
 *
 ***************************************************************************/

void Stepp(int Direction){
  HomeEndButton();
  switch(Direction){
    // one stepp to the right -> X !! 1 und 2 vertauscht
  case 1:
    if (EndX == HIGH) {      // if End-Switch is not triggert
      if (XLeftCorrection == 0) SteppRight();
      else XLeftCorrection = XLeftCorrection -1;
    }
    else if (EndX == LOW) XRightCorrection = XRightCorrection +1;
    break;
    // one stepp down -> -Y
  case 4: //2:
    if (HomeY == HIGH) {      // if Home-Switch is not triggert
      if (YUpCorrection == 0){
        SteppCheckY = SteppCheckY - 1;
        SteppDown();
        SteppDown();
        SteppDown();
      }
      else YUpCorrection = YUpCorrection -1;
    }
    else if (HomeY == LOW) YDownCorrection = YDownCorrection +1;
    break;
    // one stepp to the left -> -X
  case 3:
    if (HomeX == HIGH) {      // if Home-Switch is not triggert
      if (XRightCorrection == 0) SteppLeft();
      else XRightCorrection = XRightCorrection - 1;
    }
    else if (HomeX == LOW) XLeftCorrection = XLeftCorrection + 1;
    break;
    // one stepp up  -> Y
  case 2: //4:
    if (EndY == HIGH) {      // if End-Switch is not triggert
      if (YDownCorrection == 0){
        SteppCheckY = SteppCheckY + 1;
        SteppUp();
        SteppUp();
        SteppUp();
      }
      else YDownCorrection = YDownCorrection -1; 
    }
    else if(EndY == LOW) YUpCorrection = YUpCorrection + 1; // if End-Switch is triggert
    break;
  }
}

// one stepp to the left -> -X
void SteppLeft(){
  digitalWrite(DirPin1, LOW);
  digitalWrite(ClockPin1, HIGH);
  delayMicroseconds(Speed);
  digitalWrite(ClockPin1, LOW);
  delayMicroseconds(Speed);
}

// one stepp to the right -> X !! 1 und 2 vertauscht
void SteppRight(){
  digitalWrite(DirPin1, HIGH);
  digitalWrite(ClockPin1, HIGH);
  delayMicroseconds(Speed);
  digitalWrite(ClockPin1, LOW);
  delayMicroseconds(Speed);
}

// one stepp up  -> Y
void SteppUp(){
  digitalWrite(DirPin2, LOW);
  digitalWrite(ClockPin2, HIGH);
  delayMicroseconds(Speed2);
  digitalWrite(ClockPin2, LOW);
  delayMicroseconds(Speed2);
}

void SteppDown(){
  digitalWrite(DirPin2, HIGH);
  digitalWrite(ClockPin2, HIGH);
  delayMicroseconds(Speed2);
  digitalWrite(ClockPin2, LOW);
  delayMicroseconds(Speed2);
}






