/********************************************************************
 * Tool Control
 ********************************************************************
 *
 * - Chalk Arm Up & Down and error compensation
 * - Sponge Arm Up & Down and error compensation
 *
 ********************************************************************/



/********************************************************************/
// Move the chalk arm up and down

void ChalkArmControlDown(){
  ChalkArmSensor = digitalRead(ChalkArmSensorPin);
  if (ChalkArmSensor == LOW){ // chalk arm is up 
    ChalkArmDown();
  }
}

void ChalkArmControlUp(){ 
  ChalkArmSensor = digitalRead(ChalkArmSensorPin);
  if (ChalkArmSensor == HIGH){ // chalk arm is down
    ChalkArmUp();
  }
}

void ChalkArmDown(){
  while (ChalkArmSensor == LOW){
    ChalkArmSensor = digitalRead(ChalkArmSensorPin);
    digitalWrite(ChalkDistanceMotorPin, HIGH);
  }
  digitalWrite(ChalkDistanceMotorPin, LOW);
}

void ChalkArmUp(){
  while (ChalkArmSensor == HIGH){
    ChalkArmSensor = digitalRead(ChalkArmSensorPin);
    digitalWrite(ChalkDistanceMotorPin, HIGH);
  }
  digitalWrite(ChalkDistanceMotorPin, LOW);
}

/********************************************************************/
// Move the sponge arm up and down
// for error correction run allways both parts of the codes!
// turn on/off the sponge motor

void SpongeArmControlDown(){  
  SpongeArmSensor = digitalRead(SpongeArmSensorPin);
  if (SpongeArmSensor == LOW){ // sponge arm is up  
    SpongeArmDown();
  }
}

void SpongeArmControlUp(){ 
  SpongeArmSensor = digitalRead(SpongeArmSensorPin);
  if (SpongeArmSensor == HIGH){ // sponge arm is down
    SpongeArmUp();   
  }
}

void SpongeArmDown(){
  while (SpongeArmSensor == LOW){
    SpongeArmSensor = digitalRead(SpongeArmSensorPin);
    digitalWrite(SpongeDistanceMotorPin, HIGH);
  }
  digitalWrite(SpongeDistanceMotorPin, LOW);
}

void SpongeArmUp(){ 
  while (SpongeArmSensor == HIGH){
    SpongeArmSensor = digitalRead(SpongeArmSensorPin);
    digitalWrite(SpongeDistanceMotorPin, HIGH);
  }
  digitalWrite(SpongeDistanceMotorPin, LOW);
}

/******************************************************************/
// Turn Sponge ON an OFF

void SpongeOn(){
  digitalWrite(SpongeMotorPin, HIGH);
}

void SpongeOff(){
  digitalWrite(SpongeMotorPin, LOW);
}







