/********************************************************
 * Linear Interpolation 
 *
 * Bresenham-Algorithmus um eine Linie zu zeichnen
 ********************************************************/


void LinearInterpolation(){
  digitalWrite(StepperEnablePin, HIGH); // turn on Motor
  delayMicroseconds(Speed);
  long LineError = 0;
  FindQuadrant(); // Ermittel des Quadranten
  SteppDirection();// Schritte zuweisen
  // Ermitteln der X- und der Y-Strecke in Stepps
  XDistance = abs(XOld - XNew);   //*SteppsProMM;
  YDistance = abs(YOld - YNew);   //*SteppsProMM;
  // Bresenham-Algorithmus
  if(XDistance > YDistance) {
    for(int i=0; i < XDistance; i++) {
      Stepp(DirA);
      LineError += YDistance;
      if(LineError >= XDistance) {
        LineError -= XDistance;
        Stepp(DirB);
      }
    }
  } 
  else {
    for(int i=0; i < YDistance; i++) {
      Stepp(DirB);
      LineError += XDistance;
      if(LineError >= YDistance) {
        LineError -= YDistance;
        Stepp(DirA);
      }
    }
  }
  XOld = XNew;
  YOld = YNew;
  digitalWrite(StepperEnablePin, LOW); // turn off Motor
  delayMicroseconds(Speed);
}

// den Quadranten des neuen Punktes finden
void FindQuadrant(){
  if ((XOld <= XNew) && (YOld < YNew)){   // first Quadrant
    Quadrant = 1;
  }
  if ((XOld > XNew) && (YOld <= YNew)){   // second Quadrant
    Quadrant = 2;
  }
  if ((XOld >= XNew) && (YOld > YNew)){   // third Quadrant
    Quadrant = 3;
  }
  if ((XOld < XNew) && (YOld >= YNew)){   // forth Quadrant
    Quadrant = 4;
  }
}

// Zuweisung der Schrittrichtung entsprechend der Quadranten
void SteppDirection(){
  switch (Quadrant){
  case 1:
    DirA = 1;
    DirB = 2;
    break;
  case 2:
    DirA = 3;
    DirB = 2;
    break;
  case 3:
    DirA = 3;
    DirB = 4;
    break;
  case 4:
    DirA = 1;
    DirB = 4;
    break;
  } 
}






